IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[P_GERA_SUPRIMENTO_DIRETO_LOJA]') AND type in (N'P', N'PC'))
begin
	DROP PROCEDURE P_GERA_SUPRIMENTO_DIRETO_LOJA
end
go
CREATE PROCEDURE P_GERA_SUPRIMENTO_DIRETO_LOJA (@CD_EMP				INT, 
												@CD_PROD			VARCHAR(max),
												@CD_SIGLA_CURVA		VARCHAR(1000),
												@PAR_ESTOQUE		MONEY,
												@CD_USU				INT,
												@CONSIDERA_EST_CD	INT = 0 ,
												@CD_CTR_DEPO		INT=  1,
												@CONSIDERA_FACE		INT = 1,
												@CD_AGD_FACE		VARCHAR(1000) = '',
												@LISTA_PRECO	VARCHAR(MAX) = '',
												@CD_FILIAL		VARCHAR(max) = '',
												@PAR_EST_AA 	MONEY=NULL,
												@PAR_EST_A 		MONEY=NULL,
												@PAR_EST_B 		MONEY=NULL,
												@PAR_EST_C 		MONEY=NULL,
												@PAR_EST_D		MONEY=NULL,
												@PROD_FALTEIRO  INT=0		)										 
												  AS 

SET NOCOUNT ON;
DECLARE @CD_FILIAL_DEPOS INT, 
		@MES INT,
		@ANO INT,
		@CONSIDERA_ESEG TinyInt; 

DECLARE 
		@CD_PROD_DEF	INT, 
		@CD_FILIAL_DEF	INT,
		@PED_QTD_DEF	INT


SET @CONSIDERA_ESEG = isnull((SELECT valor FROM dbo.PRC_EMP_CONFIG pec WHERE cd_chave ='CONSIDERAR_ESEG_NECESSIDADE_DIRETO_LOJA'),0);


IF @PAR_ESTOQUE IS NULL 
	SET @PAR_ESTOQUE=0;
IF @PAR_EST_AA IS NULL 
	SET @PAR_EST_AA=@PAR_ESTOQUE;
IF @PAR_EST_A IS NULL 
	SET @PAR_EST_A=@PAR_ESTOQUE;
IF @PAR_EST_B IS NULL 
	SET @PAR_EST_B=@PAR_ESTOQUE;
IF @PAR_EST_C IS NULL 
	SET @PAR_EST_C=@PAR_ESTOQUE;
IF @PAR_EST_D IS NULL 
	SET @PAR_EST_D=@PAR_ESTOQUE;


 	IF  OBJECT_ID('TEMPDB.DBO.#RS_AUXRAT') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_AUXRAT
	END
	IF  OBJECT_ID('TEMPDB.DBO.#RS_PROD_CONSOLIDADO') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_PROD_CONSOLIDADO
	END		
	IF  OBJECT_ID('tempdb.dbo.#RS_PROD') IS NOT NULL
	BEGIN
		 DROP TABLE #RS_PROD
	END 
	

	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_PROD') AND type in (N'U'))
		DROP TABLE #RS_PROD
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_FILIAL') AND type in (N'U'))
		DROP TABLE #RS_FILIAL
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_SIGLA') AND type in (N'U'))
		DROP TABLE #RS_SIGLA
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_AGD_FACE') AND type in (N'U'))
		DROP TABLE #RS_AGD_FACE
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#PEDIDO_INTEGRADO') AND type in (N'U'))
		DROP TABLE #PEDIDO_INTEGRADO

	
	CREATE TABLE #RS_PROD(  CD_EMP				INT, 
							CD_PROD				INT, 
							FLAG_RESSUPRIMENTO_CAIXA_FECHADA INT,
							QT_UNI_RESSUPRIMENTO MONEY,
							APRES_QT_CP         MONEY 
						) 

	CREATE TABLE #RS_FILIAL (CD_EMP INT, CD_FILIAL INT)
	CREATE TABLE #RS_SIGLA (CD_SIGLA INT)
	CREATE TABLE #RS_AGD_FACE (CD_EMP INT, CD_AGD INT);

	CREATE TABLE #RS_AUXRAT ( CD_FILIAL		INT,
									CD_PROD		INT,
									EMAX			MONEY,
									QMIN			MONEY,
									QTDE_MEDIAF	MONEY,
									QT_EST		MONEY,
									QTDE_RESSUP	MONEY, 
									MEDIAF		MONEY,
									FLAG_RESSUPRIMENTO_CAIXA_FECHADA	INT,
									QT_UNI_RESSUPRIMENTO				INT,
									FLAG_RATEIO				INT,
									QT_EST_CD_DISP			MONEY,
									QT_DEMANDA_ABERTO		MONEY,
									QT_EST_MTZ				MONEY
									PRIMARY KEY (CD_FILIAL,CD_PROD));

									
	CREATE TABLE #RS_PROD_CONSOLIDADO ( CD_PROD									INT,
											QT_UNI_RESSUPRIMENTO				INT,
											FLAG_RESSUPRIMENTO_CAIXA_FECHADA	INT, 
											QT_EST_FILIAIS_SOMA					MONEY,
											QT_MEDIAF_SOMA						MONEY,
											QT_RESSUP_SOMA						MONEY,
											QT_NECESSIDADE_FILIAIS				MONEY,
											QT_DEPOSITO_INICIO					MONEY,
											QT_DEPOSITO							MONEY,
											FLAG_RATEIO							INT,
											QT_EST_CD_DISP_SOMA					MONEY);
							               			
	DELETE FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA  WHERE CD_USU= @CD_USU AND DT_CAD < CONVERT(DATE,GETDATE()); 

	SELECT 
		@MES = DATEPART(MONTH,GETDATE()),
		@ANO = DATEPART(YEAR,GETDATE())

	SELECT @CD_FILIAL_DEPOS =(SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO WHERE CD_CTR_DEPO =  @CD_CTR_DEPO );

	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#PEDIDO_INTEGRADO') AND type in (N'U'))
		DROP TABLE #PEDIDO_INTEGRADO;
 
	DELETE FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA WHERE CD_EMP=1 AND CD_USU = @CD_USU

	SET @PED_QTD_DEF =ISNULL((SELECT TOP 1 1 EXISTE 
								FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA
								WHERE CD_USU=@CD_USU),0)

IF @PED_QTD_DEF =1
BEGIN
	set @CD_PROD= ''
	INSERT INTO #RS_PROD
	SELECT 
		CD_EMP, 
		CD_PROD,
		0,
		0,
		0
	FROM 
		EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA
	WHERE 
		CD_USU=@CD_USU
		AND CD_EMP=@CD_EMP;
END
ELSE 
BEGIN
	INSERT INTO #RS_PROD
	SELECT 
		@CD_EMP, 
		ID,
		0,
		0,
		0
	FROM UFD_PRM_IN_STRING(@CD_PROD);
END

	UPDATE S 
	SET
		FLAG_RESSUPRIMENTO_CAIXA_FECHADA = ISNULL(P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,0),
		QT_UNI_RESSUPRIMENTO = ISNULL(P.QT_UNI_RESSUPRIMENTO,1) , 
		APRES_QT_CP = CONVERT(MONEY,P.APRES_QT_CP)
	FROM 
		EST_PROD P  
		join #RS_PROD S ON 
		P.CD_EMP =S.CD_EMP AND
		P.CD_PROD =S.CD_PROD
	WHERE
		P.CD_EMP =@CD_EMP;


INSERT INTO #RS_SIGLA
SELECT 
	 ID 
FROM UFD_PRM_IN_STRING(@CD_SIGLA_CURVA); 

--Tag #I001
IF @CD_AGD_FACE <>''
BEGIN
	INSERT INTO #RS_AGD_FACE
	SELECT
		@CD_EMP,
		ID 
	FROM UFD_PRM_IN_STRING(@CD_AGD_FACE);   
END


SELECT
	L.CD_COND_COMPRA, 
	L.CD_PROD, 
	L.VLR_PROD, 
	L.PERC_DESC 
INTO #RS_LISTA_PRECO 
FROM EST_PROD_PRECO_COND_COMPRA_CPL  L
	INNER JOIN #RS_PROD P ON 
	L.CD_EMP = P.CD_EMP AND
	L.CD_PROD = P.CD_PROD 
WHERE
	L.CD_EMP=@CD_EMP
	AND L.CD_COND_COMPRA IN  (SELECT ID  FROM UFD_PRM_IN_STRING(@LISTA_PRECO)) ;  


--Tratando produtos em mais de uma lista de precos
WHILE EXISTS(SELECT	
				CD_PROD 
			FROM 
				#RS_LISTA_PRECO 
			GROUP BY CD_PROD HAVING COUNT(CD_COND_COMPRA)> 1)
BEGIN
	DELETE FROM L 
	FROM 
	#RS_LISTA_PRECO L
	INNER JOIN (SELECT DISTINCT
					R.CD_PROD,
					D.CD_COND_COMPRA
				FROM
					#RS_LISTA_PRECO R
					CROSS APPLY (SELECT TOP 1
									P.CD_COND_COMPRA,
									P.CD_PROD,
									P.VLR_PROD * (1-(P.PERC_DESC/100.00)) VLR_PROD
								FROM 
									 #RS_LISTA_PRECO P  
								WHERE P.CD_PROD  = R.CD_PROD
								ORDER BY VLR_PROD DESC ) D ) D ON
		L.CD_PROD		  = D.CD_PROD AND
		L.CD_COND_COMPRA  = D.CD_COND_COMPRA  
END


if @CD_FILIAL <> ''
begin
	INSERT INTO #RS_FILIAL
	SELECT 
		@CD_EMP, 
		ID 
	FROM UFD_PRM_IN_STRING(@CD_FILIAL);
end
else
BEGIN
	INSERT INTO #RS_FILIAL
	SELECT 
		CD_EMP, 
		CD_FILIAL
	FROM PRC_FILIAL;
end

	SELECT A.CD_EMP, 
		   A.CD_AGD, 
		   A.CD_FILIAL, 
		   A.CD_PROD, 
		   A.QTDE_FACEAMENTO, 
		   A.VALID_QTDE_FACEAMENTO
	INTO #AGD_PROD
	FROM
	(
		SELECT P.CD_EMP, 
			   MAX(P.CD_AGD) CD_AGD, 
			   P.CD_FILIAL, 
			   P.CD_PROD
		FROM #RS_AGD_FACE a
			 INNER JOIN EST_PROD_CPL_FACE_AGENDA_EST_PROD p ON A.CD_EMP = P.CD_EMP
															   AND A.CD_AGD = P.CD_AGD
		WHERE P.VALID_QTDE_FACEAMENTO > DATEADD(DAY, 1, GETDATE())
		GROUP BY P.CD_EMP, 
				 P.CD_FILIAL, 
				 P.CD_PROD
	) AGD
	INNER JOIN EST_PROD_CPL_FACE_AGENDA_EST_PROD A ON AGD.CD_EMP = A.CD_EMP
													  AND AGD.CD_PROD = A.CD_PROD
													  AND AGD.CD_FILIAL = A.CD_FILIAL
													  AND AGD.CD_AGD = A.CD_AGD;




/****************************************************************************************************************************************************/
/*****************************************           CALCULA A NECESSIDADE DAS LOJAS	 	      **************************************************/
/****************************************************************************************************************************************************/
print ' CALCULA A NECESSIDADE DAS LOJAS	' + convert(varchar(10),getdate(),108)
CREATE UNIQUE CLUSTERED INDEX #ix_#RS_PROD ON #RS_PROD (CD_PROD,CD_EMP);		

SELECT      
	E.CD_EMP,    
	E.CD_FILIAL,   
	E.CD_PROD,   
	ROUND(((E.MEDIAF / 30.0000) * (E.ESEG)),0) ESEG,  
	ROUND(((E.MEDIAF / 30.0000) * (E.EMAX)),0) EMAX, 
	E.QTDE_LIMITADOR,
	ROUND(dbo.UFD_EST_AJUSTA_EMAX( CASE WHEN @CONSIDERA_FACE = 0 THEN 
										0 
									ELSE 
										ISNULL(AGD_PROD.QTDE_FACEAMENTO, E.QTDE_FACEAMENTO)  
									END, CONVERT(CHAR(10),GETDATE(),112), 
								E.QTDE_FINANCIADO, E.QTDE_LIMITADOR, 
								ROUND((E.MEDIAF / 30.0000) * E.EMAX,0) ),0) AS MAX_EMAX,  	
	ISNULL(E.QT_EST_PEND,0) QT_EST,
	0 AS NECESSIDADE,
	0 NECESSIDADE_INI,
	ROUND((E.MEDIAF / 30.0000) * (CASE 
									WHEN E.CD_SIGLA = 5 THEN @PAR_EST_AA
									WHEN E.CD_SIGLA = 1 THEN @PAR_EST_A
									WHEN E.CD_SIGLA = 2 THEN @PAR_EST_B
									WHEN E.CD_SIGLA = 3 THEN @PAR_EST_C
									WHEN E.CD_SIGLA = 4 THEN @PAR_EST_D
								END),0)   SUGESTAO,
	@CD_USU CD_USU,
	ISNULL(LST.CD_COND_COMPRA,0) CD_COND_COMPRA,
	ISNULL(LST.VLR_PROD,	CASE WHEN ISNULL(EST_PROD.VLR_FABRICA,0) > 0 THEN EST_PROD.VLR_FABRICA 
							ELSE  DBO.UFD_EST_PROD_PRECO_TBL(E.CD_EMP,E.CD_FILIAL,E.CD_PROD,1)
							END)	VLR_PROD, 
	ISNULL(LST.PERC_DESC ,0) PERC_DESC ,

	E.CD_SIGLA,
	E.MEDIAF, 
	E.QT_EST_PEND,
	0 QT_EST_MTZ,  
	ISNULL(AGD_PROD.QTDE_FACEAMENTO, E.QTDE_FACEAMENTO) FACE,
	AGD_PROD.QTDE_FACEAMENTO AGD_PROD_QTDE_FACEAMENTO,
	E.QTDE_FINANCIADO FINA,
	E.QTDE_LIMITADOR LIMITADOR,
	E.QT_PEND_ENT, 
	isnull(SS.VLR_TABELA,0) VLR_TABELA,
	VV.DT_CAD  DT_ULT_VD,
	a.qt_vd QT_VD_MES,
	0 QTDE_NECESSIDADE,
	0 QTDE_TOT,
	(E.QT_EST +  isnull(E.QT_EST_EM_TERC,0))  QT_EST_REAL,
	E.ESEG ESEG_D,  
	E.EMAX EMAX_D ,
	ROUND(dbo.UFD_EST_AJUSTA_ESEG( CASE WHEN @CONSIDERA_FACE = 0 THEN  0 
									ELSE  ISNULL(AGD_PROD.QTDE_FACEAMENTO, E.QTDE_FACEAMENTO)  
									END, CONVERT(CHAR(10),GETDATE(),112), 
								E.QTDE_FINANCIADO, 
								ROUND((E.MEDIAF / 30.0000) * E.ESEG,0) ),0) AS ESEG_COMPRA
	
	INTO  #PEDIDO_INTEGRADO
FROM  
	V_EST_PROD_CPL_ESTOQUE_PEDIDO E
	INNER JOIN EST_PROD  ON    
	E.CD_EMP	= EST_PROD.CD_EMP AND    
	E.CD_PROD	= EST_PROD.CD_PROD  

	INNER JOIN #RS_FILIAL ff on 
	E.CD_EMP	= FF.CD_EMP AND    
	E.CD_FILIAL	= FF.CD_FILIAL

	LEFT JOIN EST_PROD_CPL_VD A ON
	E.CD_EMP	= A.CD_EMP AND    
	E.CD_FILIAL	= A.CD_FILIAL AND 
	E.CD_PROD	= A.CD_PROD  
	AND A.ANO	 = @ANO
	AND A.MES	 = @MES
	AND A.CD_EMP = @CD_EMP

	LEFT JOIN EST_PROD_PRECO  SS ON    
	E.CD_EMP	= SS.CD_EMP AND    
	E.CD_FILIAL	= SS.CD_FILIAL AND 
	E.CD_PROD	= SS.CD_PROD  

	LEFT JOIN EST_PROD_CPL_ULT_MOV_PDV_VD VV ON    
	E.CD_EMP	= VV.CD_EMP AND    
	E.CD_FILIAL	= VV.CD_FILIAL AND 
	E.CD_PROD	= VV.CD_PROD  

	INNER JOIN #RS_SIGLA  S ON    
	E.CD_SIGLA	= S.CD_SIGLA 
	
	INNER JOIN #RS_PROD p on
	EST_PROD.CD_EMP		= p.CD_EMP and
	EST_PROD.CD_PROD	= p.CD_PROD 
	 
	LEFT JOIN #AGD_PROD AGD_PROD ON 
	AGD_PROD.CD_EMP  = AGD_PROD.CD_EMP AND  
	E.CD_FILIAL 		= AGD_PROD.CD_FILIAL AND 
	E.CD_PROD			= AGD_PROD.CD_PROD 
	
	LEFT JOIN #RS_LISTA_PRECO LST ON  
	EST_PROD.CD_PROD    = LST.CD_PROD   
	
WHERE  
	E.CD_EMP = @CD_EMP 
	AND E.CD_FILIAL NOT IN (SELECT 	CD_FILIAL
								FROM
									PRC_FILIAL
								WHERE
									PRC_FILIAL.FILIAL_MTZ = 1 OR  PRC_FILIAL.FLAG_OPERADOR_LOG = 1)
	AND E.STS_PROD =0   
	ANd E.STS_PROD_FILIAL =0
	AND case when @PED_QTD_DEF+@PROD_FALTEIRO > 0 then 1 else (E.MEDIAF+ ISNULL(AGD_PROD.QTDE_FACEAMENTO, E.QTDE_FACEAMENTO)  + E.QTDE_FINANCIADO + E.QTDE_LIMITADOR ) end >0;
	
 


	CREATE UNIQUE CLUSTERED INDEX #ix_TMP_PROD_CPL ON #PEDIDO_INTEGRADO (CD_PROD,CD_FILIAL,CD_EMP);		 
	 
/**********************************************************************************************************************/ 

IF @CONSIDERA_EST_CD=1 
    Begin

		UPDATE D SET
			   QT_EST = QT_EST+QT_DEPOSITO,
			   QT_EST_MTZ=QT_DEPOSITO
		   FROM 
			   #PEDIDO_INTEGRADO D
			     join  (SELECT
					   l.CD_PROD,
					   SUM((l.QT_EST + l.QT_EST_EM_TERC) - l.QT_PEND_SAI) AS QT_DEPOSITO 
				    FROM
					   V_EST_PROD_CPL_ESTOQUE_PEDIDO l
					   INNER JOIN #RS_PROD P ON 
					   L.CD_EMP = P.CD_EMP AND
					   L.CD_PROD = P.CD_PROD 
				    WHERE	
					   l.CD_EMP=@CD_EMP 
					   AND l.CD_FILIAL=@CD_FILIAL_DEPOS 
				    GROUP BY l.CD_PROD
				    HAVING SUM((l.QT_EST + l.QT_EST_EM_TERC) - l.QT_PEND_SAI) > 0 ) eCd on
				    d.CD_PROD =ecd.CD_PROD
		   
	 
	end


	-- Zera o estoque em caso de negativo	 
	UPDATE D
	SET
		QT_EST = 0
	FROM 
		#PEDIDO_INTEGRADO D
	WHERE 	
		QT_EST < 0;
	  
	--Coloca a necessidade inicial	 
	UPDATE D
	SET
		NECESSIDADE_INI = MAX_EMAX,
		NECESSIDADE		= CASE WHEN @CONSIDERA_ESEG = 1 THEN
									CASE WHEN QT_EST <= ESEG_COMPRA  THEN MAX_EMAX - QT_EST ELSE 0 END
								ELSE
									MAX_EMAX - QT_EST
								END

	FROM 
		#PEDIDO_INTEGRADO D ;
		 
	--Excesso
	UPDATE D
	SET NECESSIDADE = 0
	FROM 
		#PEDIDO_INTEGRADO D
	WHERE 	
		QT_EST > MAX_EMAX;	
	
	--sugestao
	UPDATE D				 --menos o que sobrar do estoque
	SET SUGESTAO = SUGESTAO - (CASE WHEN (NECESSIDADE_INI - QT_EST) > 0  THEN 0
									ELSE  (QT_EST - NECESSIDADE_INI)  END )
							
	FROM 
		#PEDIDO_INTEGRADO D
	 ;

		
	--sugestao
	UPDATE D
	SET SUGESTAO = 0
	FROM 
		#PEDIDO_INTEGRADO D
	WHERE
		SUGESTAO < 0;  

	 -- Aplica o Limitador
	UPDATE D
	SET
		NECESSIDADE = CASE WHEN (QTDE_LIMITADOR - QT_EST) < 0 THEN 0 
							ELSE QTDE_LIMITADOR - QT_EST END,
		SUGESTAO	= 0
	FROM 
		#PEDIDO_INTEGRADO D
	WHERE
		SUGESTAO+NECESSIDADE > 0 
		AND QTDE_LIMITADOR > 0 
		AND SUGESTAO+NECESSIDADE+ QT_EST> QTDE_LIMITADOR ; 

	UPDATE D
	SET
		QTDE_NECESSIDADE= ROUND(ISNULL(D.NECESSIDADE,0),0)+ROUND(ISNULL(D.SUGESTAO,0),0),
		QTDE_TOT= ROUND(ISNULL(D.NECESSIDADE,0),0)+ROUND(ISNULL(D.SUGESTAO,0),0)
	FROM 
		#PEDIDO_INTEGRADO D
		 

/**********************************************************************************************************************/
-- Gerando o estoque da matriz... 
/**********************************************************************************************************************/

	IF @CONSIDERA_EST_CD=10000 
	BEGIN
		Print 'Geracao do picking do estoque do CD - Time ' +convert(varchar,getdate(),108);
		Print 'Considera estoque do CD - Time ' +convert(varchar,getdate(),108);
		INSERT INTO   #RS_AUXRAT (CD_FILIAL,CD_PROD,EMAX,QMIN,
										QTDE_MEDIAF,QT_EST,QTDE_RESSUP, MEDIAF,
										FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
										QT_UNI_RESSUPRIMENTO,FLAG_RATEIO,QT_EST_CD_DISP,
										QT_DEMANDA_ABERTO,QT_EST_MTZ)	
			SELECT 
					F.CD_FILIAL,
					F.CD_PROD,
					F.EMAX,
					F.ESEG QMIN,
					F.MEDIAF QTDE_MEDIAF,
					F.QT_EST_PEND QT_EST,
					F.QTDE_TOT QTDE_RESSUP, 
					F.MEDIAF,
					P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
					P.QT_UNI_RESSUPRIMENTO,
					0 FLAG_RATEIO,
					CASE WHEN ISNULL(d.CD_EMP,0) =0 THEN 
						0 ELSE F.QTDE_TOT  END QT_EST_CD_DISP,
					0 QT_DEMANDA,
					isnull(QT_DEPOSITO_INICIO,0) QT_EST_MTZ
				FROM
					#PEDIDO_INTEGRADO F
					INNER JOIN #RS_PROD P ON 
					F.CD_PROD = P.CD_PROD
			
					LEFT JOIN (SELECT 
										CD_EMP,
										CD_PROD,
										SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) AS QT_DEPOSITO_INICIO
									FROM
										V_EST_PROD_CPL_ESTOQUE_PEDIDO
									WHERE	
										CD_EMP=@CD_EMP 
										AND CD_FILIAL=@CD_FILIAL_DEPOS 
									GROUP BY
										CD_EMP,
										CD_PROD
									HAVING SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) > 0 ) d on 
					F.CD_PROD = d.CD_PROD ;
 
			UPDATE #RS_AUXRAT SET QTDE_RESSUP =0 WHERE QTDE_RESSUP<1; 

		;WITH FILIAIS AS (SELECT	
							CD_PROD,
							QT_UNI_RESSUPRIMENTO,
							FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
							QT_EST_FILIAIS_SOMA		= SUM(r.QT_EST),
							QT_MEDIAF_SOMA			= SUM(r.QTDE_MEDIAF),
							QT_RESSUP_SOMA			= SUM(ROUND(r.QTDE_RESSUP, 0)),
							QT_NECESSIDADE_FILIAIS	= SUM(case when r.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1 then
																	ROUND((r.QTDE_RESSUP/r.QT_UNI_RESSUPRIMENTO),0)*r.QT_UNI_RESSUPRIMENTO
															else r.QTDE_RESSUP end) 
						FROM 
							#RS_AUXRAT r
							LEFT JOIN EST_RESSUP_NAO_CONSIDERA_EST_CD_PRC_FILIAL F ON  
							R.CD_FILIAL = F.CD_FILIAL AND 
							F.FLAG_HABILITADO =1
						WHERE
							F.CD_FILIAL IS NULL
						GROUP BY 
							r.CD_PROD, 
							r.QT_UNI_RESSUPRIMENTO,
							r.FLAG_RESSUPRIMENTO_CAIXA_FECHADA),
			DEPOSITO AS (SELECT
								l.CD_PROD,
								SUM((l.QT_EST + l.QT_EST_EM_TERC) - l.QT_PEND_SAI) AS QT_DEPOSITO_INICIO
							FROM
								V_EST_PROD_CPL_ESTOQUE_PEDIDO l
								INNER JOIN #RS_PROD P ON 
								L.CD_EMP = P.CD_EMP AND
								L.CD_PROD = P.CD_PROD 
							WHERE	
								l.CD_EMP=@CD_EMP 
								AND l.CD_FILIAL=@CD_FILIAL_DEPOS 
							GROUP BY
								l.CD_PROD
							HAVING SUM((l.QT_EST + l.QT_EST_EM_TERC) - l.QT_PEND_SAI) > 0 )
	  
		 
		INSERT INTO #RS_PROD_CONSOLIDADO(CD_PROD, QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
											QT_EST_FILIAIS_SOMA, QT_MEDIAF_SOMA, QT_RESSUP_SOMA, QT_NECESSIDADE_FILIAIS, 
											QT_DEPOSITO_INICIO, QT_DEPOSITO, FLAG_RATEIO)
		SELECT	
			f.CD_PROD, 
			f.QT_UNI_RESSUPRIMENTO, 
			f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
			f.QT_EST_FILIAIS_SOMA, 
			f.QT_MEDIAF_SOMA, 
			f.QT_RESSUP_SOMA, 
			f.QT_NECESSIDADE_FILIAIS, 		
			CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
				ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
			ELSE d.QT_DEPOSITO_INICIO END QT_DEPOSITO_INICIO,  
			QT_DEPOSITO = (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
								ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
							ELSE d.QT_DEPOSITO_INICIO END),
			0 FLAG_RATEIO
		FROM 
			FILIAIS f 
			INNER JOIN DEPOSITO d ON 
			d.CD_PROD=f.CD_PROD
		where
			f.QT_RESSUP_SOMA > (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
								ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
							ELSE d.QT_DEPOSITO_INICIO END) ;
 
		--DELETE FROM #RS_PROD_CONSOLIDADO WHERE QT_DEPOSITO < 1; 
		 
		UPDATE E
		SET	--Necessidade (-) o que tenho no deposito
			QT_EST_CD_DISP = CASE WHEN e.FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN 
									ROUND((ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0)/e.QT_UNI_RESSUPRIMENTO),0)* e.QT_UNI_RESSUPRIMENTO  
								ELSE ROUND((E.QTDE_RESSUP/C.QT_RESSUP_SOMA) * QT_DEPOSITO,0) END,
			E.FLAG_RATEIO=1
		FROM 
			#RS_PROD_CONSOLIDADO  C
			INNER JOIN #RS_AUXRAT E ON 
			C.CD_PROD = E.CD_PROD
		WHERE 
			QTDE_RESSUP > 0; 
		 
		--Ajusta a soma
		UPDATE s SET  
			QT_RESSUP_SOMA=QTDE_RESSUP,
			QT_DEPOSITO=QT_DEPOSITO_INICIO - QT_EST_CD_DISP,
			QT_EST_CD_DISP_SOMA=QT_EST_CD_DISP,
			FLAG_RATEIO=1
		FROM 
			#RS_PROD_CONSOLIDADO S
			INNER JOIN (SELECT CD_PROD, 
								SUM(QTDE_RESSUP) QTDE_RESSUP , 
								SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
							FROM 
								#RS_AUXRAT GROUP BY CD_PROD) E ON 
			S.CD_PROD = E.CD_PROD ;
		
		Print 'Inicio do Rateio das quantidades do CD - Time ' +convert(varchar,getdate(),108);
		--Inicio do Rateio das quantidades do CD
		WHILE EXISTS   (SELECT * FROM #RS_PROD_CONSOLIDADO s
							WHERE QT_EST_CD_DISP_SOMA <> QT_DEPOSITO_INICIO)
		begin
	
			WITH BASE AS (SELECT 
								CD_PROD, 
								FATOR_AJUSTE=CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
												QT_UNI_RESSUPRIMENTO * (case when QT_DEPOSITO_INICIO < QT_EST_CD_DISP_SOMA then -1 else 1 end)
											ELSE SIGN(QT_DEPOSITO_INICIO - QT_EST_CD_DISP_SOMA) END
								FROM 
									#RS_PROD_CONSOLIDADO 
								WHERE QT_EST_CD_DISP_SOMA <> QT_DEPOSITO_INICIO AND FLAG_RATEIO=1)
			UPDATE p 
			SET  
				QT_EST_CD_DISP =  CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
										CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
											CEILING( QTDE_RESSUP/QT_UNI_RESSUPRIMENTO ) *  QT_UNI_RESSUPRIMENTO 
										else	QTDE_RESSUP  end 
									ELSE QT_EST_CD_DISP + b.FATOR_AJUSTE  END,

				FLAG_RATEIO =  CASE WHEN  QT_EST_CD_DISP + b.FATOR_AJUSTE  > QTDE_RESSUP THEN
											0  ELSE 1 END    
			FROM 
				#RS_AUXRAT p 
				JOIN BASE b ON 
				p.CD_PROD=b.CD_PROD
			WHERE  P.FLAG_RATEIO = 1 AND p.CD_FILIAL = (SELECT	 TOP 1 CD_FILIAL
									FROM 
										#RS_AUXRAT
									WHERE 
										CD_PROD=b.CD_PROD 
										AND FLAG_RATEIO = 1
									ORDER BY 
										b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) * 30 / CASE WHEN  QTDE_MEDIAF = 0 THEN 
																												.001 ELSE QTDE_MEDIAF END, 
										b.FATOR_AJUSTE * (QT_EST_CD_DISP + QT_EST + b.FATOR_AJUSTE) );
			--Ajusta a soma
			UPDATE s SET   
				QT_EST_CD_DISP_SOMA=QT_EST_CD_DISP 
			FROM 
				#RS_PROD_CONSOLIDADO S
				INNER JOIN (SELECT CD_PROD,   
									SUM(QT_EST_CD_DISP) QT_EST_CD_DISP
								FROM 
									#RS_AUXRAT GROUP BY CD_PROD) E ON 
				S.CD_PROD = E.CD_PROD and
				QT_EST_CD_DISP_SOMA<>QT_EST_CD_DISP ;
		end   
		
		----Abate as quantidades de estoque que existem no CD
		UPDATE F
		SET 
			QTDE_TOT	  = R.QTDE_RESSUP -R.QT_EST_CD_DISP ,  
			QT_EST_MTZ  = ISNULL(R.QT_EST_MTZ,0),
			QT_PEND_ENT = F.QT_PEND_ENT + R.QT_DEMANDA_ABERTO
		FROM 
			#PEDIDO_INTEGRADO F 
			INNER JOIN #RS_AUXRAT R ON
			F.CD_FILIAL  = R.CD_FILIAL AND
			F.CD_PROD  = R.CD_PROD; 				 
	end



/*************************************************************************************************************************************/
/*************************************************************************************************************************************/
/*************************************************************************************************************************************/



IF @PED_QTD_DEF = 1
BEGIN
	UPDATE I SET QTDE_TOT=0 FROM  #PEDIDO_INTEGRADO I;

	WHILE EXISTS
	(SELECT TOP 1 CD_PROD
		FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA 
		WHERE QTDE > QTDE_RAT
			AND CD_USU= @CD_USU)
	BEGIN
		-- print @CD_PROD_DEF 
		-- print @CD_FILIAL_DEF
		SET @CD_PROD_DEF = (SELECT TOP 1 CD_PROD
								FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA 
								WHERE QTDE > QTDE_RAT
								AND CD_USU= @CD_USU)
								 
		SET @CD_FILIAL_DEF=(SELECT TOP 1 CD_FILIAL 
							FROM #PEDIDO_INTEGRADO I
							WHERE 
								CD_PROD =@CD_PROD_DEF
							ORDER BY 
								ROUND(((i.QT_EST+ isnull(I.QTDE_TOT,0)+1)/
									(CASE WHEN i.MEDIAF > 0 THEN  i.MEDIAF
									ELSE 0.0001 END))*30.000,4) ASC
									
									);

		UPDATE I
		SET
			QTDE_TOT=QTDE_TOT+1
		FROM 
			#PEDIDO_INTEGRADO I
		WHERE
			CD_PROD=@CD_PROD_DEF
			AND CD_FILIAL = @CD_FILIAL_DEF; 

		 UPDATE D
		 SET
			QTDE_RAT= QTDE_RAT+1
		 FROM 
			EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA D
		WHERE 
			CD_PROD=@CD_PROD_DEF
			AND CD_USU= @CD_USU; 
	END 
END
/****************************************************************************************************************************************************/
/****************************************************************************************************************************************************/
/****************************************************************************************************************************************************/
-- print ' INSERE EST_PROD_SUPRIMENTO_ENTREGA_LOJA' + convert(varchar(10),getdate(),108)
INSERT INTO EST_PROD_SUPRIMENTO_ENTREGA_LOJA (CD_EMP,CD_FILIAL,CD_PROD,
												CD_USU,QTDE_SUGESTAO,QTDE_NECESSIDADE,QTDE_ESTOQUE,
												QTDE_PAR_FACE_FINAN_EMAX,QTDE_LIMITADOR,CONSIDERA_EST_CD,
												CD_COND_COMPRA,QTDE_PROD,VLR_PROD,PERC_DESC,CD_SIGLA,
												MEDIAF,QT_EST,QT_EST_PEND,QT_EST_MTZ,
												MAX_EMAX,EMAX,ESEG,FACE,FINA,LIMITADOR,QT_PEND_ENT, 
												VLR_TABELA, DT_ULT_VD, QT_VD_MES, QT_VD_MES1,QT_VD_MES2 , 
												QT_VD_MES3,ESEG_D, EMAX_D,DT_CAD,
												PARAM_EST)
SELECT
	I.CD_EMP,
	I.CD_FILIAL,
	I.CD_PROD,

	I.CD_USU, 
	ROUND(I.SUGESTAO,0) SUGESTAO,
	ROUND(I.NECESSIDADE,0) NECESSIDADE, 
	I.QT_EST,
	
	I.MAX_EMAX,
	ROUND(I.QTDE_LIMITADOR,0),
	@CONSIDERA_EST_CD,
	
	i.CD_COND_COMPRA,
	i.QTDE_TOT QTDE_PROD,
	case when ISNULL(D.VLR_PROD,0) > 0 then ISNULL(D.VLR_PROD,0)
		else i.VLR_PROD end VLR_PROD, 
	case when ISNULL(D.PERC_DESC,0) > 0 then ISNULL(D.PERC_DESC,0)
		else i.PERC_DESC end PERC_DESC, 
	i.CD_SIGLA,
	
	i.MEDIAF,
	i.QT_EST_REAL,
	i.QT_EST_PEND,
	i.QT_EST_MTZ,
	
	i.MAX_EMAX,
	i.EMAX,
	i.ESEG,
	i.FACE,
	i.FINA,
	i.LIMITADOR,
	i.QT_PEND_ENT,

	i.VLR_TABELA,
	i.DT_ULT_VD, 
	isnull(i.QT_VD_MES,0),
	0 QT_VD_MES1,
	0 QT_VD_MES2,
	0 QT_VD_MES3,
	i.ESEG_D,
	i.EMAX_D,
	GETDATE(),
	@PAR_ESTOQUE
FROM
	#PEDIDO_INTEGRADO  I 
	LEFT JOIN EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA D ON
	I.CD_EMP = D.CD_EMP AND
	I.CD_PROD = D.CD_PROD AND
	D.CD_USU = @CD_USU

DELETE FROM EST_PROD_SUPRIMENTO_ENTREGA_LOJA_QTDE_DEFINIDA	WHERE CD_USU = @CD_USU;

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_PROD') AND type in (N'U'))
DROP TABLE #RS_PROD
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_FILIAL') AND type in (N'U'))
DROP TABLE #RS_FILIAL
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_SIGLA') AND type in (N'U'))
DROP TABLE #RS_SIGLA
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#RS_AGD_FACE') AND type in (N'U'))
DROP TABLE #RS_AGD_FACE
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('#PEDIDO_INTEGRADO') AND type in (N'U'))
DROP TABLE #PEDIDO_INTEGRADO
